<?php $__env->startSection('page-title', 'Create Page'); ?>

<?php $__env->startPush('css'); ?>
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
    <link href="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote-bs4.min.css" rel="stylesheet">

<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
    <div id="content" class="pmd-content admin section">
        <!-- Title -->
        <h1><?php echo $__env->yieldContent('page-title'); ?></h1>
        <!-- Breadcrumb -->
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb pmd-breadcrumb">
                <li class="breadcrumb-item"><a href="<?php echo e(route('dashboard')); ?>">Dashboard</a></li>
                <li class="breadcrumb-item">Pages</li>
                <li class="breadcrumb-item active" aria-current="page"><?php echo $__env->yieldContent('page-title'); ?></li>
            </ol>
        </nav>

        <div class="row">
            <div class="col-md-12">
                <div class="card pmd-card">
                    <form method="post" autocomplete="off" action="<?php echo e(route('insert.page')); ?>" enctype="multipart/form-data" id="page_form">
                        <?php echo csrf_field(); ?>
                        <div class="card-body">
                            <!-- Page Title & Subtitle -->
                            <div class="details-tab">
                                <h3 class="card-title">Page Information</h3>
                                <div class="row">
                                    <div class="col-12 col-sm-6 col-md-4">
                                        <label for="page-title" class="control-label">Page Title</label>
                                        <div class="form-group pmd-textfield pmd-textfield-floating-label">
                                            <input type="text" class="form-control" name="title" id="page-title" value="<?php echo e(old('title')); ?>" required>
                                            <?php $__errorArgs = ['title'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span><strong class="text-danger"><?php echo e($message); ?></strong></span>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>
                                    </div>

                                    <div class="col-12 col-sm-6 col-md-4">
                                        <label for="page-subtitle" class="control-label">Sub Title</label>
                                        <div class="form-group pmd-textfield pmd-textfield-floating-label">
                                            <input type="text" class="form-control" name="short_title" id="page-subtitle" value="<?php echo e(old('short_title')); ?>" required>
                                            <?php $__errorArgs = ['short_title'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span><strong class="text-danger"><?php echo e($message); ?></strong></span>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>
                                    </div>

                                    <div class="col-12 col-sm-6 col-md-4">
                                        <label for="team_id">Select Package</label>
                                        <select name="package_ids[]" class="form-control select2" multiple required>
                                            <option value="">Select Package</option>
                                            <?php $__currentLoopData = $packages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $package): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($package->id); ?>"><?php echo e($package->title); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                        <?php $__errorArgs = ['packages'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span><strong class="text-danger"><?php echo e($message); ?></strong></span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>

                                    <!-- Page Content -->
                                    <div class="col-12 col-sm-6 col-md-12">
                                        <label class="card-title">Page Content</label>
                                        <div class="mb-3">
                                            <textarea class="textarea form-control" name="page_content" placeholder="Place some text here" style="width: 100%; height: 200px; font-size: 14px; line-height: 18px; border: 1px solid #dddddd; padding: 10px;"></textarea>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- Template & Status -->
                        <div class="card-body">

                            <div class="details-tab">
                                <h3 class="card-title">Page Template</h3>
                                <div class="row">
                                    <div class="col-12 col-sm-6 col-md-6">
                                        <label for="template" class="control-label">Template</label>
                                        <div class="form-group pmd-textfield pmd-textfield-floating-label">
                                            <select class="form-control select2" name="template" id="template"   required>
                                                <option value="" selected>Select Template</option>
                                                <?php $__currentLoopData = $templates; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $template): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="<?php echo e($key); ?>"><?php echo e($template); ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </div>
                                    </div>

                                    <div class="col-12 col-sm-6 col-md-6">
                                        <label for="status" class="control-label">Status</label>
                                        <div class="form-group pmd-textfield pmd-textfield-floating-label">
                                            <select class="form-control" name="status" id="status" required>
                                                <option value="" selected>Select Status</option>
                                                <option value="1">Active</option>
                                                <option value="0">Inactive</option>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- SEO Settings (Optional) -->
                        <div class="card-body">

                            <div class="details-tab">
                                <h3 class="card-title">SEO (Optional)</h3>
                                <div class="row">
                                    <div class="col-12 col-sm-6 col-md-12">
                                        <label for="meta_title" class="control-label">Meta Title</label>
                                        <div class="form-group pmd-textfield pmd-textfield-floating-label">
                                            <input type="text" class="form-control" name="meta_title" id="meta_title" value="<?php echo e(old('meta_title')); ?>">
                                        </div>
                                    </div>

                                    <div class="col-12 col-sm-6 col-md-12">
                                        <label for="meta_keywords" class="control-label">Meta Keywords</label>
                                        <div class="form-group pmd-textfield pmd-textfield-floating-label">
                                            <textarea name="meta_keywords" class="form-control" placeholder="Place Meta Keywords" style="height: 50px;"><?php echo e(old('meta_keywords')); ?></textarea>
                                        </div>
                                    </div>
                                </div>
                                <label for="meta_description" class="control-label">Meta Description</label>
                                <div class="form-group pmd-textfield pmd-textfield-floating-label">
                                    <textarea name="meta_description" class="form-control" placeholder="Place Meta Description" style="height: 50px;"><?php echo e(old('meta_description')); ?></textarea>
                                </div>
                                <label for="canonical_description" class="control-label">Canonical Description</label>
                                <div class="form-group pmd-textfield pmd-textfield-floating-label">
                                    <textarea name="canonical_description" class="form-control" placeholder="Place Canonical Description" style="height: 50px;"><?php echo e(old('canonical_description')); ?></textarea>
                                </div>
                                <label for="schema_description" class="control-label">Schema Description</label>
                                <div class="form-group pmd-textfield pmd-textfield-floating-label">
                                    <textarea name="schema_description" class="form-control" placeholder="Place Schema Description" style="height: 50px;"><?php echo e(old('schema_description')); ?></textarea>
                                </div>
                            </div>
                        </div>


                        <div class="card-footer pmd-card-border">
                            <button class="btn pmd-ripple-effect btn-primary pmd-btn-raised" type="submit">Create Page</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>
    <script src="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote-bs4.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
    <script>
        $(function () {
            // Initialize Select2 for multiple select dropdown
            $('.select2').select2();
            $('.textarea').summernote({
                height: 280,
                focus: false
            });
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\projects\xampp-7.4\htdocs\laravel\teamwork\resources\views/page/create.blade.php ENDPATH**/ ?>