<?php $__env->startSection('page-title','Leads'); ?>

<?php $__env->startPush('css'); ?>
    <!-- DataTables -->
    <link rel="stylesheet" href="<?php echo e(asset('plugins/datatables-bs4/css/dataTables.bootstrap4.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('plugins/datatables-responsive/css/responsive.bootstrap4.min.css')); ?>">
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
    <!--content area start-->
    <div id="content" class="pmd-content inner-page admin">
        <!-- Title -->
        <h1 id="employee" class="text-center"><?php echo $__env->yieldContent('page-title'); ?></h1>
        <!-- End Title -->
        <!--breadcrumb start-->















        <!--breadcrumb end-->
        <div class="row pt-3">
            <div class="col-12">
                <div class="table-bg">
                    <section class="component-section" id="employee">
                        <table id='roles-datatable' class="table pmd-table table-hover pmd-table-card">
                            <thead class="thead-light">
                            <tr>
                                <th>S No.</th>

                                <th>Name</th>
                                <th>Email</th>

                                <th>Sale Type</th>
                                <th>Status</th>
                                <th>Change Status</th>
                                <th>Actions</th>
                            </tr>
                            </thead>
                            <tbody>

                            </tbody>
                        </table>
                    </section>
                </div>
            </div>
        </div>
    </div>
    <!-- content area end -->
<?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>
    <script>
        $(document).ready( function () {

            $('#roles-datatable').DataTable({
                "serverSide": true,
                "processing": true,
                "responsive": true,
                "autoWidth": false,
                "ajax": {
                    "url": "<?php echo e(route('show.leads')); ?>",
                    "dataType": "json",
                    "type": "POST",
                    "data": {_token: "<?php echo e(csrf_token()); ?>"}
                },
                "columns": [
                    {"data": "id",sortable:false},
                    // {"data": "image",sortable: false},
                    {"data": "name",sortable: false},
                    {"data": "email",sortable: false},
                    // {"data": "phone",sortable: false},
                    {"data": "sale_type",sortable: false},
                    {"data": "status_id",sortable: false},
                    {"data": "change_status",sortable: false},
                    {"data": "options",sortable: false}
                ]
            });
        } );

        $(document).on('change','.change-status', function (){
            const get_id = $(this).find(":selected").attr('data-id');
            var clientType = 'Lead';
            const get_status = $(this).find(":selected").val();

            if(get_status == 'Sale'){
                var clientType = 'Client';
            }
            // alert(clientType);
            Swal.fire({
                title: 'Are You Sure?',
                showDenyButton: true,
                showCancelButton: false,
                confirmButtonText: 'Yes',
                denyButtonText: `No`,

            }).then((result) => {
                if (result.isConfirmed) {
                    $.ajax({
                        headers: {'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')},
                        type: 'POST',
                        url: "<?php echo e(route('update-status.leads')); ?>",
                        dataType: 'json',
                        data: {get_id: get_id,get_client_type: clientType,get_status: get_status},
                        success: function (data) {

                            if (data == 'success') {

                                Swal.fire({
                                    position: 'top-end',
                                    icon: 'success',
                                    title: "Status Changed Successfully",
                                    showConfirmButton: false,
                                    timer: 1500
                                })
                                location.reload();

                            }
                        }
                    });
                }else {
                location.reload();
            }
            })
        })
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\projects\xampp-7.4\htdocs\laravel\teamwork\resources\views/leads/index.blade.php ENDPATH**/ ?>