<?php $__env->startSection('page-title','Month Wise Attendance Activity'); ?>

<?php $__env->startSection('content'); ?>
    <div id="content" class="pmd-content inner-page admin">
        <!-- Title -->
        <h1 id="employee" class="text-center"><?php echo $__env->yieldContent('page-title'); ?></h1>
        <!-- End Title -->
        <!--breadcrumb start-->
        <div class="float-right no-btn">
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb pmd-breadcrumb mb-0">
                    <li class="breadcrumb-item">
                        <a href="<?php echo e(route('dashboard')); ?>">Dashboard</a>
                    </li>
                    <li class="breadcrumb-item active" aria-current="page"><?php echo $__env->yieldContent('page-title'); ?></li>
                </ol>

            </nav>
        </div>

        <div class="row pt-3">
            <div class="col-12">
                <div class="table-bg">
                    <label  id="month">Month &nbsp;
                        <input type="month" name="start" id="start"/>
                    </label>

                    <input type="hidden" name="team_id" id="team_id" value="<?php echo e($team_member->id); ?>">
                    <section class="component-section" id="employee">
                        <table id='roles-datatable' class="table pmd-table table-hover pmd-table-card">
                            <thead class="thead-light">
                            <tr>
                                <th>S No.</th>
                                <th>Image</th>
                                <th>Name</th>
                                <th>Display Name</th>
                                <th>Total Monthly Working Hour</th>
                                <th>Monthly Working Hour Available</th>
                                <th>Total Monthly Working Days</th>
                                <th>Monthly Working Days Available</th>
                                <th>OverTime</th>
                                <th>Actions</th>

                            </tr>
                            </thead>
                            <tbody>

                            </tbody>
                        </table>
                    </section>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('css'); ?>
    <style>
        #month {
            position: absolute;
            left: 35%;
            z-index: 1;
        }
        section#employee {
            position: relative;
        }

    </style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('js'); ?>
    <script src="<?php echo e(asset('js/jquery-mask/src/jquery.mask.js')); ?>"></script>
    <script>
        $(document).ready(function () {
            var team_id =  $('#team_id').val();
            var dataTables =  $('#roles-datatable').DataTable({
                "serverSide": true,
                "processing": true,
                "responsive": true,
                "autoWidth": false,
                "ajax": {
                    "url": "<?php echo e(route('show.specific.team.employee.activity')); ?>",
                    "dataType": "json",
                    "type": "POST",
                    "data":function (data) {
                        var month = $('#start').val();
                        data.month = month;
                        data._token = "<?php echo e(csrf_token()); ?>";
                        data.id = team_id;
                    }
                },
                "columns": [
                    {"data": "id",sortable:false},
                    {"data": "image",sortable: false},
                    {"data": "name",sortable: false},
                    {"data": "client_display_name",sortable: false},
                    {"data": "working_hour_total",sortable: false},
                    {"data": "working_hour_avaliable",sortable: false},
                    {"data": "total_month_working_days",sortable: false},
                    {"data": "available_working_days",sortable: false},
                    {"data": "over_time",sortable: false},
                    {"data": "options",sortable: false}
                ]
            });

            $(document).on("change",'#month',function (e) {
                 dataTables.draw();
                // var month = $('#start').val();
                // alert(month);
            });
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\projects\xampp\htdocs\laraveltwo\wamztech-crm\app2\resources\views/users/showSpecificTeamUser.blade.php ENDPATH**/ ?>