<?php $__env->startSection('page-title', 'Edit Package'); ?>

<?php $__env->startPush('css'); ?>
    <link href="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote-bs4.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>

    <div id="content" class="pmd-content admin section">
        <!-- Title -->
        <h1><?php echo $__env->yieldContent('page-title'); ?></h1>

        <!-- Breadcrumb -->
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb pmd-breadcrumb">
                <li class="breadcrumb-item"><a href="<?php echo e(route('dashboard')); ?>">Dashboard</a></li>
                <li class="breadcrumb-item">Packages</li>
                <li class="breadcrumb-item active" aria-current="page"><?php echo $__env->yieldContent('page-title'); ?></li>
            </ol>
        </nav>
        <!-- End breadcrumb -->

        <div class="row">
            <div class="col-md-12">
                <div class="card pmd-card">
                    <form method="post" autocomplete="off" action="<?php echo e(route('update.package')); ?>" enctype="multipart/form-data" id="page_form">
                        <?php echo csrf_field(); ?>
                        <input type="hidden" name="id" value="<?php echo e($package->id); ?>">
                        <div class="card-body">
                            <!-- Page Title & Subtitle -->
                            <div class="details-tab">
                                <h3 class="card-title">Update Package Information</h3>
                                <div class="row">
                                    <div class="col-12 col-sm-6 col-md-6">
                                        <label for="page-title" class="control-label">Title</label>
                                        <div class="form-group pmd-textfield pmd-textfield-floating-label">
                                            <input type="text" class="form-control" name="title" id="page-title" value="<?php echo e($package->title); ?>" required>
                                            <?php $__errorArgs = ['title'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span>
                                                <strong class="text-danger"><?php echo e($message); ?></strong>
                                            </span>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>
                                    </div>
                                    <div class="col-12 col-sm-6 col-md-6">
                                        <label for="status" class="control-label">Package Type</label>
                                        <div class="form-group pmd-textfield pmd-textfield-floating-label">
                                            <select class="form-control" name="pkg_type" required>
                                                <option value="" selected disabled>Select</option>
                                                <option <?php if($package->pkg_type == 'Website Development'): ?> selected <?php endif; ?> value="Website Development">Website Development</option>
                                                <option <?php if($package->pkg_type == 'Logo Design'): ?> selected <?php endif; ?> value="Logo Design">Logo Design</option>
                                                <option <?php if($package->pkg_type == 'Video Animation Services'): ?> selected <?php endif; ?> value="Video Animation Services">Video Animation Services</option>
                                                <option <?php if($package->pkg_type == 'Website Maintenance'): ?> selected <?php endif; ?> value="Website Maintenance">Website Maintenance</option>
                                                <option <?php if($package->pkg_type == 'Mobile Application'): ?> selected <?php endif; ?> value="Mobile Application">Mobile Application</option>
                                                <option <?php if($package->pkg_type == 'Digital Marketing Services'): ?> selected <?php endif; ?> value="Digital Marketing Services">Digital Marketing Services</option>
                                            </select>
                                        </div>
                                    </div>

                                    <div class="col-12 col-sm-6 col-md-6">
                                        <label for="status" class="control-label">User Package Display</label>
                                        <div class="form-group pmd-textfield pmd-textfield-floating-label">
                                            <select class="form-control" name="user_package_display" required>
                                                <option value="" selected disabled>Select</option>
                                                <option <?php if($package->user_package_display == 'website'): ?> selected <?php endif; ?> value="website">Website</option>
                                                <option <?php if($package->user_package_display == 'ads'): ?> selected <?php endif; ?> value="ads">Ads</option>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-12 col-sm-6 col-md-6">
                                        <label for="page-title" class="control-label">Price</label>
                                        <div class="form-group pmd-textfield pmd-textfield-floating-label">
                                            <input type="text" class="form-control" name="price" value="<?php echo e($package->price); ?>" required>
                                            <?php $__errorArgs = ['price'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span><strong class="text-danger"><?php echo e($message); ?></strong></span>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>
                                    </div>

                                    <div class="col-12 col-sm-6 col-md-6">
                                        <label for="page-title" class="control-label">Discounted Price</label>
                                        <div class="form-group pmd-textfield pmd-textfield-floating-label">
                                            <input type="text" class="form-control" name="discounted_price" value="<?php echo e($package->discounted_price); ?>" required>
                                            <?php $__errorArgs = ['discounted_price'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span><strong class="text-danger"><?php echo e($message); ?></strong></span>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>
                                    </div>

                                    <div class="col-12 col-sm-6 col-md-6">
                                        <label for="status" class="control-label">Status</label>
                                        <div class="form-group pmd-textfield pmd-textfield-floating-label">
                                            <select class="form-control" name="status" id="status" required>
                                                <option value="" disabled selected>Select Status</option>
                                                <option <?php if($package->status == 1): ?> selected <?php endif; ?> value="1">Active</option>
                                                <option <?php if($package->status == 0): ?> selected <?php endif; ?> value="0">In Active</option>

                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-12 col-sm-6 col-md-6">
                                        <label for="web_type" class="control-label">Website Type(If website Package)</label>
                                        <div class="form-group pmd-textfield pmd-textfield-floating-label">
                                            <select class="form-control" name="web_type" id="web_type">
                                                <option value="" selected disabled>Select Type</option>
                                                <option <?php if($package->web_type == 'Website Design'): ?> selected <?php endif; ?> value="Website Design">Website Design</option>
                                                <option <?php if($package->web_type == 'E-Commerce Website'): ?> selected <?php endif; ?> value="E-Commerce Website">E-Commerce Website</option>
                                            </select>
                                        </div>
                                    </div>
                                    <!-- Page Content -->
                                    <div class="col-12 col-sm-6 col-md-12">
                                        <label class="card-title">Page Content</label>
                                        <div class="mb-3">
                                            <textarea class="textarea form-control" name="description" placeholder="Place some text here" style="width: 100%; height: 200px; font-size: 14px; line-height: 18px; border: 1px solid #dddddd; padding: 10px;"><?php echo e($package->description); ?></textarea>
                                        </div>
                                    </div>
                                    <div class="col-12 col-sm-6 col-md-12">
                                        <label class="card-title">Different Style Content</label>
                                        <div class="mb-3">
                                            <textarea class="textarea form-control" name="different_style_desc" placeholder="Place some text here" style="width: 100%; height: 200px; font-size: 14px; line-height: 18px; border: 1px solid #dddddd; padding: 10px;"><?php echo e($package->different_style_desc); ?></textarea>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="card-footer pmd-card-border">
                            <button class="btn pmd-ripple-effect btn-primary pmd-btn-raised" type="submit">Update Package</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>
    <script src="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote-bs4.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
    <script>
        $(function () {
            // Initialize Select2 for multiple select dropdown
            $('.select2').select2();
            $('.textarea').summernote({
                height: 280,
                focus: false
            });
        });
        var numbers = document.getElementsByClassName('amount-input');
        // Loop through each element and attach the event listener.
        for (var i = 0; i < numbers.length; i++) {
            numbers[i].onkeydown = function(e) {
                if (!((e.keyCode >= 96 && e.keyCode <= 105) // Numpad keys
                    || (e.keyCode >= 48 && e.keyCode <= 57) // Number keys
                    || e.keyCode === 8)) { // Backspace
                    e.preventDefault(); // Prevent the default action
                }
            };
        }
    </script>
<?php $__env->stopPush(); ?>


<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\projects\xampp-7.4\htdocs\laravel\teamwork\resources\views/packages/edit.blade.php ENDPATH**/ ?>