<?php $__env->startSection('page-title', 'Packages'); ?>

<?php $__env->startPush('css'); ?>
    <!-- DataTables -->
    <link rel="stylesheet" href="<?php echo e(asset('plugins/datatables-bs4/css/dataTables.bootstrap4.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('plugins/datatables-responsive/css/responsive.bootstrap4.min.css')); ?>">
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
    <!-- Content Wrapper. Contains page content -->
    <div id="content" class="pmd-content inner-page admin">
        <!-- Title -->
        <h1 id="employee" class="text-center"><?php echo $__env->yieldContent('page-title'); ?></h1>
        <!-- End Title -->
        <!--breadcrumb start-->
        <div class="float-right <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->denies('create.client')): ?> no-btn <?php endif; ?>">
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb pmd-breadcrumb mb-0">
                    <li class="breadcrumb-item">
                        <a href="<?php echo e(route('dashboard')); ?>">Dashboard</a>
                    </li>
                    <li class="breadcrumb-item active" aria-current="page"><?php echo $__env->yieldContent('page-title'); ?></li>
                </ol>
            </nav>
        </div>
        <div>
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create.package')): ?>
                <a href="<?php echo e(route('create.package')); ?>" class="btn btn-primary ">Create Package</a>
            <?php endif; ?>
        </div>
        <!-- Main content -->
        <div class="row pt-3">
            <div class="col-12">
                <div class="table-bg">
                    <section class="component-section" id="employee">
                        <table id="roles-datatable" class="table pmd-table table-hover pmd-table-card">
                            <thead class="thead-light">
                            <tr>
                                <th>S.no</th>
                                <th>Title</th>
                                <th>Package Display</th>
                                <th>Price</th>
                                <th>Discounted Price</th>
                                <th>Status</th>

                                
                                <th>Actions</th>
                            </tr>
                            </thead>
                            <tbody>
                            <?php $__currentLoopData = $packages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $package): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($index + 1); ?></td> <!-- Display sequential number -->
                                    <td><?php echo e($package->title); ?></td>
                                    <td><?php echo e($package->user_package_display); ?></td>
                                    <td>$<?php echo e($package->price); ?></td>
                                    <td>$<?php echo e($package->discounted_price); ?></td>
                                    <td>
                                        <?php if($package->status == 1): ?>
                                            <span class="badge badge-success"> Active </span>
                                        <?php else: ?>
                                            <span class="badge badge-danger"> In Active </span>
                                        <?php endif; ?>
                                    </td>

                                    
                                    <td>
                                        <div class="btn-group btn-group-sm">
                                            <a href="<?php echo e(route('edit.package', ['id' => $package->id])); ?>" class="btn btn-info"><i class="fas fa-edit"></i></a>
                                            <button class="btn btn-danger delete_package" data-id="<?php echo e($package->id); ?>"><i class="fas fa-trash"></i></button>
                                        </div>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </section>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>
    <script>
        $(function () {
            // Initialize DataTable
            $("#roles-datatable").DataTable({
                "responsive": true,
                "autoWidth": false,
                "columnDefs": [
                    { orderable: false, targets: 0 }  // Disable sorting on the checkbox column
                ]
            });

            // Handle delete single page action
            $(document).on('click', '.delete_package', function(e) {
                var ids = [$(this).attr('data-id')];
                removeByIds(ids);
            });


            // Remove pages by IDs
            function removeByIds(ids) {
                Swal.fire({
                    title: 'Are you sure?',
                    text: 'You will not be able to recover these packages!',
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonText: 'Yes, delete it!',
                    cancelButtonText: 'Cancel'
                }).then((result) => {
                    if (result.isConfirmed) {
                        // Make the AJAX request to delete the pages
                        $.ajax({
                            url: '<?php echo e(route('delete.package')); ?>',
                            type: 'POST',
                            data: {
                                _token: '<?php echo e(csrf_token()); ?>',
                                ids: ids
                            },
                            success: function(response) {
                                if (response.success) {
                                    Swal.fire({
                                        icon: 'success',
                                        title: 'Deleted!',
                                        text: 'The selected packages have been deleted.',
                                        // confirmButtonText: 'OK'
                                    }).then(() => {
                                        location.reload();  // Reload the page after successful deletion
                                    });
                                } else {
                                    Swal.fire({
                                        icon: 'error',
                                        title: 'Something went wrong',
                                        text: 'Please try again later.',
                                        confirmButtonText: 'OK'
                                    });
                                }
                            },
                            error: function() {
                                Swal.fire({
                                    icon: 'error',
                                    title: 'An error occurred',
                                    text: 'There was an error while deleting the packages.',
                                    confirmButtonText: 'OK'
                                });
                            }
                        });
                    }
                });
            }
        });
    </script>

<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\projects\xampp-7.4\htdocs\laravel\teamwork\resources\views/packages/index.blade.php ENDPATH**/ ?>