
<html>

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
    <title>Website Design Company in Burlington | Anax Designs</title>
        
    <link rel="icon" type="image/x-icon" href="<?php echo e(asset('images/favicon.png')); ?>">

    <link href="<?php echo e(asset('assets/css/font.css')); ?>" rel="stylesheet">
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/css/default.css')); ?>">
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/css/style.css')); ?>">
    <!-- Global site tag (gtag.js) - Google Analytics -->
    <script async="" src="https://www.googletagmanager.com/gtag/js?id=G-EQF3NVSWHK"></script>
    <script>
        window.dataLayer = window.dataLayer || [];  function gtag(){dataLayer.push(arguments);}  gtag('js', new Date());  gtag('config', 'G-EQF3NVSWHK');
    </script>

    <script type="application/ld+json">
        { "@context": "https://schema.org", "@type": "Product", "brand": "AnaxDesigns", "name": " Website Design Company in Burlington ", "description": " We commissioned Ana X Designs to develop our web site in late 2020, a challenging year for everyone by any
        measure. My primary contact was Jack, but I want to emphasize that the entire staff was always friendly, responsive, and exceedingly adept. Not once did they ever express frustration, disrespect, or impatience. This was my team’s first web site
        project, so there was a lot of anxiety and uncertainty. You should hold no similar anxieties with Ana X Designs at the helm. They were always helpful, insightful, and willing to take our concerns and perspectives into consideration during the
        development cycle. We are excited to be launching our new enterprise in the next few weeks, and we simply could not have done it without Ana X Designs. With sincerest warmth and appreciation, our team thanks you!", "aggregateRating": { "@type":
        "AggregateRating", "ratingValue": 4.1, "bestRating": 5, "reviewCount": 36 }, "review" : { "@type" : "Review", "author" : { "@type" : "Person", "name" : "Brian Frisk" }, "reviewRating" : { "@type" : "Rating", "ratingValue":"4.1" } } }
    </script>

    <script type="application/ld+json">
        { "@context": "https://schema.org/", "@type": "BreadcrumbList", "
        <i></i>temListElement": [{ "@type": "ListItem", "position": 1, "name": "Homepage", "item": "https://www.anaxdesigns.com/" },{ "@type": "ListItem", "position": 2, "name": " Website Design Company in Burlington ", "item": " https://www.anaxdesigns.com/website-design-burlington-vt/"
        }] }
    </script>

    <script type="application/ld+json">
        { "@context": "https://schema.org", "@type": "FAQPage", "mainEntity": [{ "@type": "Question", "name": "Why use Anax Designs website design services?", "acceptedAnswer": { "@type": "Answer", "text": "
        <p>1. Trusting your website design to web design experts will save a lot of time and energy for you. By electing Anax Designs for web design solutions, you can ponder over the growth of your trade. Our web design services are ideal for freelancers,
            and small and medium-sized businesses. It&apos;s for someone who desires a professional online presence but doesn&apos;t have the staff or time. </p>
        <p>2. Our website designers build a website for you that echoes your image and is optimized for search engines (SEO), which contain the metadata. SEO content is necessary for a good ranking on search engines like Google, Bing, etc.</p "
    }
  },{
    "@type  ": "Question ",
    "name ": "How do I place my order? ",
    "acceptedAnswer ": {
      "@type  ": "Answer ",
      "text ": "Would you like to entrust the creation of your website to the Anax Designs experts? Fill out the contact form and one of the team members will call you back to discuss your wishes and requirements. You can also order the responsive web
            design services directly from this page. "
    }
  },{
    "@type  ": "Question ",
    "name ": "How exactly does the proposed service work? ",
    "acceptedAnswer ": {
      "@type  ": "Answer ",
      "text ": "Not only do our web designers create your web pages, but we advise and support you before, during, and after the publication of your website. Overview of the procedure: <p>1. Would you like to entrust the creation of your website to
        the Anax Designs experts? Fill out our contact form and one of our experts will call you back to discuss your wishes and requirements. You can also order the responsive web design services directly from this page. </p>
        <p>2. During this first exchange, we explain in detail how it works and review your preferences and requirements for your site. </p>
        <p>3. Then, our team creates your new custom website respecting your ideas down to the smallest detail.
        </p>
        <p>4. Once ready, we present the project to you and discuss it with you. After taking your feedback into account, our team of experts makes the other minor necessary changes and adjustments.
        </p> We will keep you up-to-date about the progress of your website by email. This way, you always get the latest info. The objective is to build a website that reveals your image and get it online as quickly as possible. Once you&apos;re completely
        satisfied with your site’s appearance, we&apos;ll publish it: it will be visible on search engines such as Google or Bing. To keep your site updated, we offer website maintenance services. Our professionals can make regular changes depending on
        the package you have bought." } },{ "@type": "Question", "name": "If I already have a website, can I benefit from Anax Designs&apos; website design service?", "acceptedAnswer": { "@type": "Answer", "text": "Even if you already possess a website,
        you&apos;ve come to the right spot as we are a top website design company in Burlington. Our web design experts can use text and images from your old site again to create a fresh one. We will also be glad to assist you in to handover of your domain."
        } },{ "@type": "Question", "name": "How long does it take to create my custom website?", "acceptedAnswer": { "@type": "Answer", "text": "The sooner you provide us with all the details about your website&apos;s content and approvals, the sooner
        our experts can design, develop, and publish it." } },{ "@type": "Question", "name": "Are SEO and text writing included in the service?", "acceptedAnswer": { "@type": "Answer", "text": "We ensure we optimize your website and its content for search
        engines. This is how, your online presence will be definitely found on Google or Bing, for instance. Obviously, you can send us your content, but we can also write it for you." } },{ "@type": "Question", "name": "I don&apos;t know anything about
        website design, what should I do?", "acceptedAnswer": { "@type": "Answer", "text": "Don&apos;t worry, we&apos;ll lead you through the process! For instance, if you don&apos;t have your images, we will select suitable illustrations together from
        our broad image library, which covers several areas of activity." } },{ "@type": "Question", "name": "What happens once my site goes live?", "acceptedAnswer": { "@type": "Answer", "text": "Your site must remain relevant to search engines. That’s
        why optimizing and updating your site&apos;s content is essential. This increases the possibility that new visitors will find you." } },{ "@type": "Question", "name": "How do I know if my site is performing?", "acceptedAnswer": { "@type": "Answer",
        "text": "We want your website to be a long-standing achievement. Once our expert website design company in Burlington completes it, you have access to the website performance analysis tool. You can see the statistics of visitors to your website
        and how they have changed over time." } }] }
    </script>
</head>
<style>
    @font-face{font-family:FigtreeVF;src:url(chrome-extension://majdfhpaihoncoakbjgbdhglocklcgno/fonts/FigtreeVF.woff2) format("woff2 supports variations"),url(chrome-extension://majdfhpaihoncoakbjgbdhglocklcgno/fonts/FigtreeVF.woff2) format("woff2-variations");font-weight:100 1000;font-display:swap}
    .vc_col-lg-4 {width: 33.33%;}
</style>


<body class="home">
<header id="masthead" class="site-header header-3 both-types no-transition" data-header-fixed="true" data-fixed-initial-offset="150">
    <div class="header-wrap">
        <div class="header-wrap-inner">
            <div class="left-part">
                <div class="site-branding">
                    <div class="site-title">
                        <a href="https://www.anaxdesigns.com/" rel="home" class="remove_underline">
                            <div class="logo"><img src="<?php echo e(asset('images/anax_design_logo.png')); ?>" alt="ANAX LOGO"></div>
                            <div class="fixed-logo"><img src="<?php echo e(asset('images/anax_design_logo.png')); ?>" alt="ANAX LOGO"></div>
                        </a>
                    </div>

                    <a href="javascript:;" class="get-menu"><span></span></a>

                </div>
            </div>
            <div class="menu-sec">
                <a href="javascript:;" class="menu-cls"></a>
                <div class="brand-logo"><img src="<?php echo e(asset('images/anax_design_logo.png')); ?>" alt="ANAX LOGO"></div>
                <nav id="site-navigation" class="main-nav with-counters">
                    <div class="main-nav-container">
                        <ul class="menu">
                            <li class="nav-item menu-item-depth-0 first"><a href="https://www.anaxdesigns.com/"><span>HOME</span></a></li>
                            <li class="nav-item menu-item-depth-0"><a href="https://www.anaxdesigns.com/about-us/"><span>ABOUT US </span></a></li>
                            <li class="nav-item menu-item-depth-0"><a href="https://www.anaxdesigns.com/projects/"><span>PROJECTS </span></a></li>
                            <li class="nav-item menu-item-depth-0"><a href="https://www.anaxdesigns.com/portfolio/"><span>PORTFOLIO </span></a></li>
                            <li class="nav-item menu-item-depth-0 child-menu"><a href="javascript:;"><span>SERVICES </span></a>
                                <ul class="sub-menu">
                                    <li class="first"><a href="https://www.anaxdesigns.com/creative-logo-design/">Logo Design</a></li>
                                    <li><a href="https://www.anaxdesigns.com/website-development/">Website Design &amp; Development</a></li>
                                    <li><a href="https://www.anaxdesigns.com/video-animation-services/">Animation</a></li>
                                    <li><a href="https://www.anaxdesigns.com/website-maintenance/">Website Maintenance</a></li>
                                    <li><a href="https://www.anaxdesigns.com/mobile-application/">Mobile Application</a></li>
                                    <li class="last"><a href="https://www.anaxdesigns.com/digital-marketing-services/">Digital Marketing</a></li>
                                </ul>
                            </li>
                            <li class="nav-item menu-item-depth-0 last"><a href="https://www.anaxdesigns.com/packages/"><span>PACKAGES </span></a></li>
                        </ul>
                    </div>
                </nav>
                <div class="right-part">
                    <a class="btn purchase-btn small order_button3" pkg="Header Form" href="javascript:;">Contact Us</a>
                    <a class="btn purchase-btn small" href="tel:(877) 908 8719">(877) 908 8719</a>
                </div>
            </div>
        </div>
    </div>
</header>
<div class="burlington_pg">
    <div class="industries-sec black_bg">
        <div class="container">
            <div class="row">
                <div class="col-md-6">
                    <div class="industries-slider owl-carousel owl-theme owl-loaded owl-drag">
                        <div class="owl-stage-outer">
                            <div class="owl-stage" style="transform: translate3d(-2880px, 0px, 0px); transition: 0.45s; width: 4608px;">
                                <div class="owl-item" style="width: 576px;">
                                    <div class="single-box">
                                        <div class="thumb">
                                            <figure><img src="<?php echo e(asset('images/burlington/burlington-logo-1.webp')); ?>" alt="website design company in Burlington" width="540" height="344"></figure>
                                        </div>
                                    </div>
                                </div>
                                <div class="owl-item" style="width: 576px;">
                                    <div class="single-box">
                                        <div class="thumb">
                                            <figure><img src="<?php echo e(asset('images/burlington/burlington-logo-2.webp')); ?>" alt="website design company in Burlington" width="540" height="344"></figure>
                                        </div>
                                    </div>
                                </div>
                                <div class="owl-item" style="width: 576px;">
                                    <div class="single-box">
                                        <div class="thumb">
                                            <figure><img src="<?php echo e(asset('images/burlington/burlington-logo-3.webp')); ?>" alt="web design company in Burlington" width="540" height="344"></figure>
                                        </div>
                                    </div>
                                </div>
                                <div class="owl-item active" style="width: 576px;">
                                    <div class="single-box">
                                        <div class="thumb">
                                            <figure><img src="<?php echo e(asset('images/burlington/burlington-logo-4.webp')); ?>" alt="web design Burlington" width="540" height="344"></figure>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="owl-nav">
                            <button type="button" role="presentation" class="owl-prev"><span aria-label="Previous">‹</span></button>
                            <button type="button" role="presentation" class="owl-next"><span aria-label="Next">›</span></button>
                        </div>
                    </div>
                </div>
                <div class="col-md-5">
                    <div class="industries-page-banner-summary">
                        <h1>Expert Website Design Company in Burlington, VT</h1>
                        <p>As the best website design company in Burlington, VT, we specialize in creating striking, user-friendly websites that raise your brand and drive results.</p>
                        <ul>
                            <li class="first">Custom domain and email to strengthen your brand</li>
                            <li class="last">Website maintenance services: updating and maintaining your site after it goes live</li>
                        </ul>
                    </div>
                </div>
            </div>
            <!--<div class="client-sec">
            <ul>
                <li><figure><a href="assets-new/images/client-1.png"><img src="https://www.anaxdesigns.com/assets-new/images/client-1.png"></a></figure></li>
                <li><figure><a href="assets-new/images/client-2.png"><img src="https://www.anaxdesigns.com/assets-new/images/client-2.png"></a></figure></li>
                <li><figure><a href="assets-new/images/client-3.png"><img src="https://www.anaxdesigns.com/assets-new/images/client-3.png"></a></figure></li>
                <li><figure><a href="assets-new/images/client-4.png"><img src="https://www.anaxdesigns.com/assets-new/images/client-4.png"></a></figure></li>
            </ul>
        </div>-->
        </div>
    </div>

    <div class="cst_breadcumbs">
        <div class="container">
            <ul class="breadcumb">
                <li class="first"><a href="https://www.anaxdesigns.com/">Home</a></li>
                <li><span class="sep">&gt;</span></li>
                <li class="last"><span>Web Design Company in Burlington</span></li>
            </ul>
        </div>
    </div>

    <div class="industry-page-section">
        <div class="container-fluid">
            <div class="row">
                <div class="col-md-6">
                    <div class="industry-about-image">
                        <figure><img src="<?php echo e(asset('images/burlington/webteam1.webp')); ?>" alt="Burlington web design" width="463" height="344"></figure>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="about-text">
                        <h2 class="cstm_h2">The Burlington Website Design of Your Dreams in Just a Few Steps</h2>
                    </div>
                    <div class="content-slider owl-carousel owl-theme owl-loaded owl-drag">

                        <div class="owl-stage-outer">
                            <div class="owl-stage" style="transform: translate3d(-1197px, 0px, 0px); transition: 0.45s; width: 2793px;">
                                <div class="owl-item" style="width: 399px;">
                                    <div class="content-box">
                                        <h5 class="cstm_h2">Telephone interview</h5>
                                        <p>If you have decided to get your site designed and developed, the top <a href="https://www.anaxdesigns.com/website-design-burlington-vt/">website design company in Burlington</a> will arrange a telephone appointment
                                            to discuss your expectations.</p>
                                    </div>
                                </div>
                                <div class="owl-item active" style="width: 399px;">
                                    <div class="content-box">
                                        <h5 class="cstm_h2">Design &amp; Content</h5>
                                        <p>Your site is designed by our team of experts at a number one <a href=" https://maps.app.goo.gl/PCFnYxcdFGJvrSyF9" target="_blank" data-type="link" data-id=" https://maps.app.goo.gl/PCFnYxcdFGJvrSyF9" rel="noreferrer noopener"> website design company in Burlington </a>,
                                            specializing in web design and development, web writing, and SEO.</p>
                                    </div>
                                </div>
                                <div class="owl-item" style="width: 399px;">
                                    <div class="content-box">
                                        <h5 class="cstm_h2">Validation and publication</h5>
                                        <p>After just a few days, you can see what your site will look like. A few more small adjustments? We apply them and your site is ready!</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <a href="javascript:;" class="get-startbtn order_button3">Get Started </a>
                </div>
            </div>
        </div>
    </div>

    <div class="industry-page-section empower-your-st gray_bg">
        <div class="container-fluid">
            <div class="row">
                <div class="col-md-4">
                    <div class="content-box">
                        <h5 class="cstm_h2">Our Team of Experts</h5>
                    </div>
                    <div class="about-text">
                        <h2 class="cstm_h2">Work with a Burlington Website Design Agency</h2>
                    </div>
                    <div class="content-slider owl-carousel owl-theme owl-loaded owl-drag">


                        <div class="owl-stage-outer">
                            <div class="owl-stage" style="transform: translate3d(-798px, 0px, 0px); transition: 0.45s; width: 2394px;">
                                <div class="owl-item active" style="width: 399px;">
                                    <div class="content-box">
                                        <p>Our experts create a website with up to 7 pages for you. For example, your site can contain a homepage, a company profile page, a product page, or a team overview page. Additional pages can also be added.</p>
                                        <p>Our SEO specialists do what is necessary to ensure that the content of your site is visible on Google.</p>
                                        <p>If you <a href="https://www.anaxdesigns.com/creative-logo-design/">need a creative logo design</a> or images, we can help. And if you already have your own logo and/or personal photos, we can of course integrate
                                            them.</p>
                                    </div>
                                </div>
                                <div class="owl-item" style="width: 399px;">
                                    <div class="content-box">
                                        <h5 class="cstm_h2">Finishing Touches</h5>
                                        <p>Your business at its best After creating your site, we check all the content together by going through each page with you. When you’re fully satisfied with the result, we help you publish your website.</p>
                                        <p>Once your website is live, you just need to get in touch with us if you want to make any changes.</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <a href="javascript:;" class="get-startbtn order_button3">Get Started </a>
                </div>
                <div class="col-md-6">
                    <div class="industry-about-image">
                        <figure><img src="<?php echo e(asset('images/burlington/webteam3.webp')); ?>" alt="website design Burlington" width="382" height="344"></figure>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="industry-page-section">
        <div class="container-fluid">
            <div class="row">
                <div class="col-md-6">
                    <div class="industry-about-image">
                        <figure><img src="<?php echo e(asset('images/burlington/webteam2.webp')); ?>" alt="website design company in Burlington" width="532" height="344"></figure>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="about-text">
                        <h3 class="cstm_h2">Burlington Web Design with Comprehensive Maintenance Services</h3>
                    </div>
                    <div class="content-slider owl-carousel owl-theme owl-loaded owl-drag">

                        <div class="owl-stage-outer">
                            <div class="owl-stage" style="transform: translate3d(-798px, 0px, 0px); transition: all; width: 1995px;">
                                <div class="owl-item" style="width: 399px;">
                                    <div class="content-box">
                                        <h5 class="cstm_h2">We keep your site up-to-date</h5>
                                        <p>Regular changes are beneficial for your site. That's why we continue to support you after your website goes live, making the small and large changes you need for you.</p>
                                        <p>We update your contact information, special offers, or change your photos.</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <a href="javascript:;" class="get-startbtn order_button3">Get Started </a>
                </div>
            </div>
        </div>
    </div>

    <div class="our_services line gray_bg">
        <div class="container">
            <div class="custom-heading">
                <h2 class="cstm_h2">Services from the Leading Web Design Company in Burlington</h2>
                <p>We already have created thousands of websites for our clients not only in <a href="https://www.anaxdesigns.com/website-design-burlington-vt/">Burlington, VT</a> but also in the entire United States.</p>
            </div>
            <div class="row">
                <div class="col-md-4">
                    <div class="service_box">
                        <div class="service_box_thumb">
                            <img src="<?php echo e(asset('images/burlington/tick.svg')); ?>" alt="website design company in Burlington" width="25" height="25">
                        </div>
                        <div class="service_box_content">
                            <h5>Site designed for users</h5>
                            <p>Ease of use is key: we don't just create perfect website design; we also optimize the user experience.</p>
                        </div>
                    </div>
                    <div class="service_box">
                        <div class="service_box_thumb">
                            <img src="<?php echo e(asset('images/burlington/tick.svg')); ?>" alt="website design company in Burlington" width="25" height="25">
                        </div>
                        <div class="service_box_content">
                            <h5>Modern Templates</h5>
                            <p>Choose your template from modern templates suitable for all activities: your content is displayed perfectly on all screens (tablets, smartphones, and PCs).</p>
                        </div>
                    </div>
                    <div class="service_box">
                        <div class="service_box_thumb">
                            <img src="<?php echo e(asset('images/burlington/tick.svg')); ?>" alt="website design company in Burlington" width="25" height="25">
                        </div>
                        <div class="service_box_content">
                            <h5>Domain and email address</h5>
                            <p>Many private email addresses such as @gmail.com or @yahoo.com are used. Make a difference with a personalized email address, based on your domain name.</p>
                        </div>
                    </div>
                </div>

                <div class="col-md-4">
                    <div class="service_box">
                        <div class="service_box_thumb">
                            <img src="<?php echo e(asset('images/burlington/tick.svg')); ?>" alt="web design company in Burlington" width="25" height="25">
                        </div>
                        <div class="service_box_content">
                            <h5>Referencing</h5>
                            <p>We optimize your text for search engines to enhance your visibility on Google and increase the number of your visitors</p>
                        </div>
                    </div>
                    <div class="service_box">
                        <div class="service_box_thumb">
                            <img src="<?php echo e(asset('images/burlington/tick.svg')); ?>" alt="web design company in Burlington" width="25" height="25">
                        </div>
                        <div class="service_box_content">
                            <h5>High-performance platform</h5>
                            <p>Your website is designed with WordPress. From the Anax Designs platform, you can access your website data, and emails and add products.</p>
                        </div>
                    </div>
                    <div class="service_box">
                        <div class="service_box_thumb">
                            <img src="<?php echo e(asset('images/burlington/tick.svg')); ?>" alt="web design company in Burlington" width="25" height="25">
                        </div>
                        <div class="service_box_content">
                            <h5>Maintenance &amp; Updates</h5>
                            <p>We update your website for you after it's live. The frequency of changes depends on the package you have chosen.</p>
                        </div>
                    </div>
                </div>

                <div class="col-md-4">
                    <div class="service_box">
                        <div class="service_box_thumb">
                            <img src="<?php echo e(asset('images/burlington/tick.svg')); ?>" alt="website design company in Burlington" width="25" height="25">
                        </div>
                        <div class="service_box_content">
                            <h5>Protected data</h5>
                            <p>Our team of specialists will assist you effectively in the creation of your cookie policy.</p>
                        </div>
                    </div>
                    <div class="service_box">
                        <div class="service_box_thumb">
                            <img src="<?php echo e(asset('images/burlington/tick.svg')); ?>" alt="High-performance platform" width="25" height="25">
                        </div>
                        <div class="service_box_content">
                            <h5>SSL Encryption</h5>
                            <p>Your website is secured with SSL encryption, which protects you and your visitors, and also helps improve your rankings on Google.</p>
                        </div>
                    </div>
                    <div class="service_box">
                        <div class="service_box_thumb">
                            <img src="<?php echo e(asset('images/burlington/tick.svg')); ?>" alt="Site designed for users" width="25" height="25">
                        </div>
                        <div class="service_box_content">
                            <h5>Security</h5>
                            <p>Our systems are always up-to-date and with automated security checks, your website is protected from unauthorized access.</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <section class="package pattern_bg home-package-sec">
        <div class="page-container">
            <div class="sec-heading" data-aos="fade-up" data-aos-delay="0">
                <h2 class="cstm_h2">Website Design Packages</h2>
            </div>
            <div class="row">
                <?php $__currentLoopData = $packages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $package): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?> <?php echo $package->description; ?> <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </section>


    <div class="industry-page-section faq_sec gray_bg">
        <div class="container">
            <div class="custom-heading">
                <h4 class="cstm_h2">FAQ – Frequently Asked Questions</h4>
            </div>
            <div class="accord">
                <div class="faq-box">
                    <div class="acrd active">
                        <h5>Why use Anax Designs' website design services? </h5>
                    </div>
                    <div class="drop-acrd">
                        <p>Trusting your website design to web design experts will save a lot of time and energy for you. By electing Anax Designs for <a href="https://www.anaxdesigns.com/">web design solutions</a>, you can concentrate on the development
                            of your business. Our web design services are ideal for freelancers, small businesses, and medium-sized businesses. It's for someone who desires a professional online presence but doesn't have the staff or time.</p>
                        <p>Our website designers build a website for you that echoes your image and is optimized for search engines (SEO), which contain the metadata. SEO content is necessary for a good ranking on search engines like Google, Bing, etc.</p>
                    </div>
                </div>
                <div class="faq-box">
                    <div class="acrd active">
                        <h5>How do I place my order?</h5>
                    </div>
                    <div class="drop-acrd">
                        <p>Would you like to entrust the creation of your website to the Anax Designs experts? Fill out our contact form and one of our experts will call you back to discuss your wishes and requirements. You can also order the <a href="https://www.anaxdesigns.com/">responsive web design services</a>
                        </p>
                    </div>
                </div>
                <div class="faq-box">
                    <div class="acrd active">
                        <h5>How exactly does the proposed service work?</h5>
                    </div>
                    <div class="drop-acrd">
                        <p>Not only do our web designers create your web pages, but we advise and support you before, during, and after the publication of your website</p>
                        <p>Overview of the procedure:</p>
                        <p>When you place an order on our website, you can directly schedule a phone call with our experts.</p>
                        <p>During this first exchange, we explain in detail how it works and review your preferences and requirements for your site.</p>
                        <p>Then, our team creates your new custom website respecting your ideas down to the smallest detail.</p>
                        <p>Once ready, we present the project to you and discuss it with you. After taking your feedback into account, our team of experts makes the other minor necessary changes and adjustments.</p>
                        <p>We will keep you informed of the <a href=" https://www.squarespace.com/website-design " target="_blank" rel=" nofollow noopener noreferrer"> evaluation of your website by email </a> This way, you always get the latest info.</p>
                        <p>The objective is to build a website that reveals your image and get it online as quickly as possible.</p>
                        <p>Once you're completely satisfied with your site’s appearance, we'll publish it: it will be visible on search engines such as Google or Bing.</p>
                        <p>To keep your site updated, we offer <a href="https://www.anaxdesigns.com/website-maintenance/">website maintenance services</a>. Our professionals can make regular changes depending on the package you have picked.</p>
                    </div>
                </div>
                <div class="faq-box">
                    <div class="acrd active">
                        <h5>If I already have a website, can I benefit from Anax Designs' website design service? </h5>
                    </div>
                    <div class="drop-acrd">
                        <p>Even if you already possess a website, you've come to the right spot as we are a top website design company in Burlington. Our web design experts can use text and images from your old site again to create a fresh one. We will
                            also be glad to help you with your domain.</p>
                        <p>Our website designers build a website for you that echoes your image and is <a href="https://www.anaxdesigns.com/digital-marketing-services/">optimized for search engines (SEO)</a>, which contain the metadata. SEO content is
                            necessary for a good ranking on search engines like Google, Bing, etc.</p>
                    </div>
                </div>

                <div class="faq-box">
                    <div class="acrd active">
                        <h5>How Long Does It Take to Build My Custom Website? </h5>
                    </div>
                    <div class="drop-acrd">
                        <p>The sooner you provide us with all the details about your website's content and approvals, the sooner our experts can design, develop, and publish it.</p>
                    </div>
                </div>

                <div class="faq-box">
                    <div class="acrd active">
                        <h5>Are SEO and text writing included in the service?</h5>
                    </div>
                    <div class="drop-acrd">
                        <p>We ensure we optimize your website and its content for search engines. This is how, your online presence will be definitely found on Google or Bing, for instance. Obviously, you can send us your content, but we can also write
                            it for you as per the package you opt.</p>
                    </div>
                </div>

                <div class="faq-box">
                    <div class="acrd active">
                        <h5>I don't know anything about website design, what should I do?</h5>
                    </div>
                    <div class="drop-acrd">
                        <p>Don't worry, we'll lead you through the procedure! For instance, if you don't have your images, we will select suitable illustrations together from our broad image library, which covers several areas of activity.</p>
                    </div>
                </div>

                <div class="faq-box">
                    <div class="acrd active">
                        <h5>What happens once my site goes live? </h5>
                    </div>
                    <div class="drop-acrd">
                        <p>Your site must remain relevant to search engines. That’s why optimizing and updating your site's content is essential. This increases the possibility that new visitors will find you.</p>
                    </div>
                </div>

                <div class="faq-box">
                    <div class="acrd active">
                        <h5>How do I know if my site is performing?</h5>
                    </div>
                    <div class="drop-acrd">
                        <p>We want your website to be a long-standing achievement. Once our expert website design company in Burlington completes it, you have access to the website performance analysis tool. You can see the statistics of visitors to
                            your website and how they have changed over time.</p>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="burlington_location">
        <div class="location">
            <iframe src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d91075.28894870538!2d-73.30904918490103!3d44.492560778155806!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x4cca7a55b69b55e5%3A0xc35fe519720e498e!2sBurlington%2C%20VT!5e0!3m2!1sen!2sus!4v1714401449474!5m2!1sen!2sus"
                    width="600" height="450" style="border:0;" allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade"></iframe>
        </div>
    </div>

</div>


<div class="footer-testimonial gray_bg">
    <div class="wrapper ftr-poilet">
        <div class="container-text">
            <h2 data-aos="fade-up" data-aos-delay="0"><a href="https://www.trustpilot.com/review/anaxdesigns.com" target="blank">Anax Designs is rated <br> <span>Excellent</span></a></h2>
            <figure data-aos="fade-up" data-aos-delay="100"><img src="<?php echo e(asset('images/ratedimage.png')); ?>" alt=" Trust Pilot Reviews " width="371" height="131"></figure>
            <div class="main-comment vc_hidden-md" data-aos="fade-up" data-aos-delay="200">
                <div class="main-comment-slider owl-carousel owl-theme owl-loaded owl-drag">
                    <div class="owl-stage-outer">
                        <div class="owl-stage" style="transform: translate3d(-1800px, 0px, 0px); transition: 0.45s; width: 6300px;">
                            <div class="owl-item active" style="width: 900px;">
                                <div class="main-comment-content">
                                    <div class="parallax-home">
                                        <h3><b>Joy</b> <span> Terrific experience!</span></h3>
                                        <p>Very helpful designers, with a nice turn around time. It felt like my account and design mattered - and that is exactly what I needed! The design was definitely a reflection of what the ministry of Joy In
                                            All Seasons is. A huge shout out to Oscar for answering each and every question with patience and a smile.
                                            <br>Thank you, Anax Designs!</p>
                                    </div>
                                </div>
                            </div>
                            <div class="owl-item" style="width: 900px;">
                                <div class="main-comment-content">
                                    <div class="parallax-home">
                                        <h3><b>Michel Maillet</b> <br> <span> A Cross Border Logo</span></h3>
                                        <p>Overall the service was great and quite easy to deal with in terms of accessibility. Whenever I had a concern, modifications, whatever it be, I could send a quick email and would normally receive a response
                                            very quickly. All things said and done, my logo was created.</p>
                                    </div>
                                </div>
                            </div>
                            <div class="owl-item" style="width: 900px;">
                                <div class="main-comment-content">
                                    <div class="parallax-home">
                                        <h3><b>Alyssa Elizabeth Marsh</b> <br> <span> I am over the moon for my logo!</span></h3>
                                        <p>I sent them very vague ideas for my logo because I hadn't put much thought into getting a company to design one for me, but they still rocked it and designed multiple logos for me to choose from. They got
                                            back to me with them incredibly fast and I was so in love with all of the logos. I am extremely satisfied with my purchase and the quick responses I received. Just amazed!</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>


<footer class="site-footer footer-sec clb-section-dark">
    <div class="page-container">
        <div class="row">
            <div class="col-lg-3 col-md-3 col-sm-6" data-aos="fade-up" data-aos-delay="0">
                <div class="theme-logo">
                    <a href="https://www.anaxdesigns.com/"><img loading="lazy" srcset="<?php echo e(asset('images/footer-logo.png')); ?>" src="<?php echo e(asset('images/footer-logo.png')); ?>" class="main-logo svg-logo" alt="ANAX LOGO"></a>
                </div>
            </div>
            <div class="col-lg-3 col-md-3 col-sm-6" data-aos="fade-up" data-aos-delay="100">
                <ul>
                    <!--<li class="widget">
                    <h3 class="widget-title">Loactaion</h3>
                    <p>200 Continental Dr #3744, <br> Newark, DE 19713, USA</p>
                </li>-->
                    <li class="widget first last">
                        <h3 class="widget-title">WORK INQUIRIES</h3>
                        <p>Interested in working with us?</p>
                        <a href="mailto:sales@anaxdesigns.com" class="vc_hidden-xs">sales@anaxdesigns.com</a>
                    </li>
                </ul>
            </div>
            <div class="col-lg-3 col-md-3 col-sm-6" data-aos="fade-up" data-aos-delay="200">
                <ul>
                    <li class="widget first last">
                        <h3 class="widget-title">PHONE NUMBER</h3>
                        <p>Contact with us?</p>
                        <a href="tel:(877) 908 8719" class="vc_hidden-xs"> (877) 908 8719</a>
                    </li>
                </ul>
            </div>
            <div class="col-lg-3 col-md-3 col-sm-6" data-aos="fade-up" data-aos-delay="300">
                <ul>
                    <li class="widget first last">
                        <p></p>
                        <figure><img loading="lazy" srcset="<?php echo e(asset('images/card-img.png')); ?>" src="https://www.anaxdesigns.com/assets-new/images/card-img.png"></figure>
                        <p></p>
                        <figure><img loading="lazy" srcset="<?php echo e(asset('images/positivessl_trust.png')); ?>" src="https://www.anaxdesigns.com/assets-new/images/positivessl_trust.png"></figure>
                    </li>
                </ul>
                <!--<div class="payment-sec">
                <figure><img loading="lazy" srcset="https://www.anaxdesigns.com/assets-new/images/card-img.png" src="https://www.anaxdesigns.com/assets-new/images/card-img.png"></figure>
            </div>
            <div class="widget">
                <h3 class="widget-title">Sign up for the newsletter</h3>
                <div class="subscribe-form">
                        <input type="text" name="your-email" value="" size="40" placeholder="Name" />
                        <input type="email" name="your-email" value="" size="40" placeholder="Email address" />
                        <input type="tel" name="your-email" value="" size="40" placeholder="Phone" />
                        <select>
                            <option>I AM INTERESTED IN</option>
                            <option>I AM NOT INTERESTED IN</option>
                        </select>
                    <br>
                    <input type="submit" value="Sign Up" class="wpcf7-form-control wpcf7-submit" />
                </div>
            </div>-->
            </div>
        </div>
    </div>
    <div class="site-info">
        <div class="page-container">
            <div class="site-info-holder clearfix">
                <div class="left"> Copyright © 2024 Anaxdesigns.com </div>
                <div class="right"> <a href="https://www.anaxdesigns.com/privacy-policy/">Privacy Policy</a> | <a href="https://www.anaxdesigns.com/terms-and-conditions/">Terms of Service</a> </div>
            </div>
        </div>
    </div>
</footer>
<section id="logo_form" class="popup-form"> <span class="close"></span>
    <div class="form-body">
        <a href="javascript:;" title="" class="close"></a>
        <div class="formcontainer">
            <div class="tophead">
                <h2>Discuss your Project</h2>
                <h3>Free Consultation</h3> </div>
            <div id="popupform" class="inform">
                <form class="logo_form creative-logo-design-packages-3-forms" action="https://www.anaxdesigns.com/code/anax/signupSubmitAPI" method="post" autocomplete="off" id="popupForm">
                    <div class="field">
                        <input type="text" name="name" maxlength="60" placeholder="Name *" class="required alphanumeric iecn" required="">
                    </div>
                    <div class="field">
                        <input type="text" name="email" maxlength="60" value="" placeholder="Email *" class="required email " required="">
                    </div>
                    <div class="field phone">
                        <input type="text" maxlength="25" minlength="10" name="phone" value="" placeholder="Phone Number *" class="required number" required="">
                    </div>
                    <div class="field">
                        <textarea name="message_discount" class="required iemsg" rows="4" placeholder="Tell us about your project"></textarea>
                    </div>
                    <div id="recaptcha-form-2"></div> <span><b class="logo_form-recaptcha-req" style="display:none;">CAPTCHA IS REQUIRED</b></span>
                    <div class="clearfix fieldwrap chkbx">
                        <input type="checkbox" name="chk_confirmation" class="" value="" required=""> By submitting this form and signing up for texts, you consent to receive text messages </div>
                    <div class="clearfix fieldwrap text-center">
                        <input type="submit" class="btn-validate" value="Submit">
                        <input type="hidden" name="type" id="pkg-name" value="Logo Form">
                        <input type="hidden" name="pkg" value="Popup Form">
                        <input type="hidden" name="return_url" value="https://www.anaxdesigns.com/promo-offer/?q=1">
                        <input name="pkg-price" id="pkg-price" value="199" type="hidden">
                        <input name="page_url" class="page_url" value="https://www.anaxdesigns.com/" type="hidden">
                        <input type="hidden" id="payment_url" name="payment_url" value="https://www.anaxdesigns.com/promo-offer">
                        <input id="price_he_saw" name="price_he_saw" value="199" type="hidden">
                        <input name="second_price" value="" type="hidden">
                        <input name="third_price" value="0" type="hidden"> </div>
                </form>
            </div>
        </div>
    </div>
</section>

<section id="website_form" class="popup-form">
    <span class="close"></span>
    <div class="form-body">
        <a href="javascript:;" title="" class="close"></a>
        <div class="formcontainer">
            <div class="tophead">
                <h2>Discuss your Project</h2>
                <h3>Free Consultation</h3>
            </div>
            <div id="popupform" class="inform">
                <form class="website_form" action="https://www.anaxdesigns.com/code/anax2/signupSubmitAPI_new" method="post" autocomplete="off" id="popupForm">
                    <div class="field">
                        <input type="text" name="name" maxlength="60" placeholder="Name *" class="required alphanumeric iecn" required="">
                    </div>
                    <div class="field">
                        <input type="text" name="email" maxlength="60" value="" placeholder="Email *" class="required email" required="">
                    </div>
                    <div class="field phone">
                        <input type="text" maxlength="25" minlength="10" name="phone" value="" placeholder="Phone Number *" class="required number" required="">
                    </div>
                    <div class="field">
                        <textarea name="message_discount" class="required iemsg" rows="4" placeholder="Tell us about your project"></textarea>
                    </div>
                    <!--<div id="recaptcha-form-3"></div>-->
                    <!--<span><b class="website_form-recaptcha-req" style="display:none;"  >CAPTCHA IS REQUIRED</b></span>-->
                    <div class="clearfix fieldwrap chkbx">
                        <input type="checkbox" name="chk_confirmation" class="" value="" required=""> By submitting this form and signing up for texts, you consent to receive text messages
                    </div>
                    <div class="clearfix fieldwrap text-center">
                        <input type="submit" class="btn-validate" value="Submit">
                        <input type="hidden" name="type" class="web_type" value="Website Form">
                        <input type="hidden" id="pkg-name" name="pkg" value="Website Form">
                        <input type="hidden" id="price_he_saw" name="price_he_saw" value="149.99">
                        <input type="hidden" name="payment_url" id="payment_url" value="https://www.anaxdesigns.com/website-brief">
                        <input type="hidden" name="return_url" class="return_url" value="https://www.anaxdesigns.com/website-brief">
                        <input type="hidden" name="page_url" class="page_url_web" value="https://www.anaxdesigns.com/">
                        <input name="second_price" value="" type="hidden">
                        <input name="third_price" value="0" type="hidden">
                        <input type="hidden" name="random_code" value="">
                    </div>
                </form>
            </div>
        </div>
    </div>
</section>

<script type="text/javascript" src="<?php echo e(asset('assets/js/xJquery.js')); ?>"></script>
<script type="text/javascript" src="<?php echo e(asset('assets/js/script.js')); ?>"></script>
<script type="text/javascript" src="<?php echo e(asset('assets/js/owl.carousel.min.js')); ?>"></script>

<!-- Start of  Zendesk Widget script -->
<script id="ze-snippet" src="https://static.zdassets.com/ekr/snippet.js?key=f3c91184-16ca-4754-ab8d-b39d980e2cd5">
</script>
<!-- End of  Zendesk Widget script -->
<iframe data-product="web_widget" title="No content" role="presentation" tabindex="-1" allow="microphone *" aria-hidden="true" src="about:blank" style="width: 0px; height: 0px; border: 0px; position: absolute; top: -9999px;"></iframe>
<div id="veepn-breach-alert"></div>
<div>
    <iframe title="Opens a widget where you can find more information" id="launcher" tabindex="-1" style="color-scheme: light; width: 108px; height: 50px; padding: 0px; margin: 10px 20px; position: fixed; bottom: 30px; overflow: visible; opacity: 0; border: 0px; z-index: 999998; transition-duration: 250ms; transition-timing-function: cubic-bezier(0.645, 0.045, 0.355, 1); transition-property: opacity, top, bottom; top: -9999px; visibility: hidden;"></iframe>
</div>
</body>

</html>
<?php /**PATH D:\projects\xampp-7.4\htdocs\laravel\teamwork\resources\views/templates/website-design-burlington-vt.blade.php ENDPATH**/ ?>