<?php $__env->startSection('page-title','Update Client'); ?>

<?php $__env->startPush('css'); ?>
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>

    <div id="content" class="pmd-content admin section">
        <!-- Title -->
        <h1><?php echo $__env->yieldContent('page-title'); ?></h1>
        <!-- End Title -->
        <!--breadcrumb start-->
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb pmd-breadcrumb">
                <li class="breadcrumb-item">
                    <a href="<?php echo e(route('dashboard')); ?>">Dashboard</a>
                </li>
                <li class="breadcrumb-item">Clients</li>
                <li class="breadcrumb-item active" aria-current="page"><?php echo $__env->yieldContent('page-title'); ?></li>
            </ol>
        </nav>
        <!--breadcrumb end-->

        <div class="row">
            <div class="col-md-12">
                <div class="card pmd-card">
                    <form method="post" autocomplete="off" action="<?php echo e(route('update.client')); ?>" id="user_form" enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>
                        <input type="hidden" name="id" value="<?php echo e($client->id); ?>">
                        <div class="card-body">
                            <!-- Upload Picture -->
                            <div class="details-tab">
                                <h3 class="card-title mb-3">Profile Picture</h3>
                                <div data-provides="fileinput" class="fileinput fileinput-new">
                                    <div data-trigger="fileinput" class="fileinput-preview thumbnail img-fluid rounded-circle mb-0">
                                        <?php if($client->gender == 'Male'): ?>
                                            <img alt="Profile-Pic" src="<?php echo e(asset(isset($client->image) ? 'employees/images/'.$client->image : 'themes/images/dummy.png')); ?>" class="profile-pic rounded-circle pmd-z-depth-light-2-1 mr-md-4 mr-sm-0" height="200" width="200">
                                        <?php else: ?>
                                            <img alt="Profile-Pic" src="<?php echo e(asset(isset($client->image) ? 'employees/images/'.$client->image : 'themes/images/dummy-female.png')); ?>" class="profile-pic rounded-circle pmd-z-depth-light-2-1 mr-md-4 mr-sm-0" height="200" width="200">
                                        <?php endif; ?>
                                    </div>
                                    <div class="action-button">
                                        <span class="btn btn-secondary pmd-btn-fab btn-sm pmd-btn-raised btn-file pmd-ripple-effect">
                                            <span class="fileinput-new"><i class="material-icons pmd-xs">add</i></span>
                                            <span class="fileinput-exists"><i class="material-icons pmd-xs">mode_edit</i></span>
                                            <input type="file" name="file">
                                        </span>
                                        <a data-dismiss="fileinput" class="btn btn-danger btn-sm pmd-btn-fab pmd-ripple-effect pmd-btn-raised btn-file fileinput-exists" href="javascript:void(0);"><i class="material-icons pmd-sm">close</i></a>
                                    </div>
                                </div>
                            </div>

                            <!-- Basic Information -->
                            <div class="details-tab">
                                <h3 class="card-title">Client Information</h3>
                                <div class="row">
                                    <div class="col-12 col-sm-6 col-md-4">
                                        <div class="form-group pmd-textfield pmd-textfield-floating-label ">
                                            <label for="fn" class="col-form-label control-label">First Name</label>
                                            <input type="text" class="form-control" name="firstname"
                                                   aria-describedby="emailHelp" id="fn" value="<?php echo e(old('firstname')??$client->firstname); ?>" required>
                                            <?php $__errorArgs = ['firstname'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span>
                                                <strong class="text-danger"><?php echo e($message); ?></strong>
                                            </span>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>
                                    </div>
                                    <div class="col-12 col-sm-6 col-md-4">
                                        <div class="form-group pmd-textfield pmd-textfield-floating-label ">
                                            <label for="ln" class="col-form-label control-label">Last Name</label>
                                            <input type="text" class="form-control" name="lastname" id="ln"
                                                   aria-describedby="emailHelp" value="<?php echo e(old('lastname')??$client->lastname); ?>" required>
                                            <?php $__errorArgs = ['lastname'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span>
                                                <strong class="text-danger"><?php echo e($message); ?></strong>
                                            </span>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>
                                    </div>

                                    <div class="col-12 col-sm-6 col-md-4">
                                        <div class="form-group pmd-textfield pmd-textfield-floating-label ">
                                            <label for="phone" class="col-form-label control-label">Phone</label>
                                            <input type="text" class="form-control" name="phone"
                                                   aria-describedby="emailHelp" id="phone" value="<?php echo e(old('phone')??$client->phone); ?>" required>
                                            <?php $__errorArgs = ['phone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span>
                                                <strong class="text-danger"><?php echo e($message); ?></strong>
                                            </span>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>
                                    </div>
                                    <div class="col-12 col-sm-6 col-md-4">
                                        <div class="form-group pmd-textfield pmd-textfield-floating-label ">
                                            <label for="personal-email" class="col-form-label control-label">Email</label>
                                            <input type="email" class="form-control" name="email" id="personal-email"
                                                   aria-describedby="emailHelp" value="<?php echo e(old('email')??$client->email); ?>" required>

                                            <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span>
                                                <strong class="text-danger"><?php echo e($message); ?></strong>
                                            </span>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>
                                    </div>
                                    <div class="col-12 col-sm-6 col-md-4">
                                        <label for="email" class="d-block title-label">Gender</label>
                                        <div class="custom-control custom-radio pmd-radio custom-control-inline">
                                            <input type="radio" id="male" name="gender" class="custom-control-input" value="Male"
                                                   <?php if($client->gender == 'Male'): ?> checked <?php endif; ?> required>
                                            <label class="custom-control-label pmd-radio-ripple-effect" for="male">Male</label>
                                        </div>
                                        <div class="custom-control custom-radio pmd-radio custom-control-inline">
                                            <input type="radio" id="female" name="gender" class="custom-control-input" value="Female"
                                                   <?php if($client->gender == 'Female'): ?> checked <?php endif; ?>>
                                            <label class="custom-control-label pmd-radio-ripple-effect" for="female">Female</label>
                                        </div>
                                    </div>
                                    <div class="col-12 col-sm-6 col-md-3">
                                        <label for="marital" class="d-block title-label">Marital Status</label>
                                        <div class="custom-control custom-radio pmd-radio custom-control-inline">
                                            <input type="radio" id="married" name="marital_status" class="custom-control-input" value="Married"
                                                   <?php if($client->marital_status == 'Married'): ?> checked <?php endif; ?> required>
                                            <label class="custom-control-label pmd-radio-ripple-effect" for="married">Married</label>
                                        </div>
                                        <div class="custom-control custom-radio pmd-radio custom-control-inline">
                                            <input type="radio" id="unmarried" name="marital_status" class="custom-control-input" value="Unmarried"
                                                   <?php if($client->marital_status == 'Unmarried'): ?> checked <?php endif; ?>>
                                            <label class="custom-control-label pmd-radio-ripple-effect" for="unmarried">Unmarried</label>
                                        </div>
                                    </div>

                                    <div class="col-12 col-md-6 col-lg-6">
                                        <div class="form-group pmd-textfield pmd-textfield-floating-label ">
                                            <label for="role">Role Permission</label>
                                            <select name="role_id" id="role_id" class="form-control " required>
                                                <option value="" hidden></option>
                                                <?php $__empty_1 = true; $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                                    <option value="<?php echo e($role->id); ?>"
                                                            <?php if($client->findRole): ?> <?php if($client->findRole->name == $role->name): ?> selected <?php endif; ?> <?php endif; ?>><?php echo e($role->name); ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                                <?php endif; ?>
                                            </select>
                                            <?php $__errorArgs = ['role_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span>
                                                <strong class="text-danger"><?php echo e($message); ?></strong>
                                            </span>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>
                                    </div>

                                    <div class="col-12 col-sm-6 col-md-3">
                                        <div class="form-group pmd-textfield pmd-textfield-floating-label ">
                                            <label for="status_id">Status</label>
                                            <select name="status_id" id="status_id" class="form-control" >
                                                <option></option>
                                                <?php $__currentLoopData = $status; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $st): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="<?php echo e($st->id); ?>" <?php if($client->status_id == $st->id): ?> selected <?php endif; ?>><?php echo e($st->title); ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                            <?php $__errorArgs = ['status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span>
                                                <strong class="text-danger"><?php echo e($message); ?></strong>
                                            </span>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>
                                    </div>

                                </div>
                            </div>
                        </div>

                        <div class="card-footer pmd-card-border">
                            <button class="btn pmd-ripple-effect btn-primary pmd-btn-raised form_submit_btn" type="submit">Update</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>
    <script src="<?php echo e(asset('js/jquery-mask/src/jquery.mask.js')); ?>"></script>
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>

    <script>
        let global_sum = 0;
        $(document).ready(function () {
            $('#phone').mask("00000000000");
            $('.select-two').select2();
        });

        var dateToday = new Date();
        // Add start date date and time picker
        $('#datepickerjoin').datetimepicker({
            minDate: dateToday,
            format: 'DD-MM-YYYY'
        });


    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\projects\xampp-7.4\htdocs\laravel\teamwork\resources\views/clients/edit.blade.php ENDPATH**/ ?>